<?php 
    /**
    *
    * copyright (c) 2013-2021 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo https://www.geecom.org/index.php?id=34&alias=linee-guida-per-l%2527uso-del-logo-geecom
    * 
    * Controller dei Gruppi
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreTraduzioni.php";
    include "../classi/GeneratoreUrl.php";
    include "../localizzazione/stringheDaTradurre.php";
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb = new DbManager($costantiDatabase);
    
    // le impostazioni servono per ottenere l'indirizzo del sito da inviare al server
    $impostazioni = $geecomDb->leggiSingolaRiga("geecB_impostazioni", 1);
    $gestoreTraduzioni = new GestoreTraduzioni("../localizzazione", array("italiano","inglese","tedesco","francese","spagnolo"));
    
    // dato che serve in molti switch per capire la pagina a cui l'utente deve essere rediretto
    $datiProdottoGeecom = $geecomDb->leggiSingolaRiga("geec_prodotti", 1) ;
    $percorsoGeecomCMS  = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    session_start();
    controlloAccessoAdmin();
    if(isset($_POST["operazione"])) {
        $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
    }
    else {
        $operazione = filter_input(INPUT_GET,"operazione",FILTER_SANITIZE_STRING);
    }
    
    switch ($operazione) {
        case 'aggiornaTraduzioni':
           
            $traduzioniItaliano = array();
            $traduzioniInglese  = array();
            $traduzioniTedesco  = array();
            $traduzioniFrancese = array();
            $traduzioniSpagnolo = array();
            
            foreach($stringheDaTradurre as $stringa) {
                $traduzioniItaliano[$stringa] = $_POST[str_replace(array(" ","."),"_",$stringa)."-italiano"];
                $traduzioniInglese[$stringa]  = $_POST[str_replace(array(" ","."),"_",$stringa)."-inglese"];
                $traduzioniTedesco[$stringa]  = $_POST[str_replace(array(" ","."),"_",$stringa)."-tedesco"];
                $traduzioniFrancese[$stringa] = $_POST[str_replace(array(" ","."),"_",$stringa)."-francese"];
                $traduzioniSpagnolo[$stringa] = $_POST[str_replace(array(" ","."),"_",$stringa)."-spagnolo"];
            }
            
            $gestoreTraduzioni->modificaFileTraduzione("italiano", $traduzioniItaliano);
            $gestoreTraduzioni->modificaFileTraduzione("inglese", $traduzioniInglese);
            $gestoreTraduzioni->modificaFileTraduzione("tedesco", $traduzioniTedesco);
            $gestoreTraduzioni->modificaFileTraduzione("francese", $traduzioniFrancese);
            $gestoreTraduzioni->modificaFileTraduzione("spagnolo", $traduzioniSpagnolo);
            header("Location: $percorsoGeecomCMS/impostazioni.php?status=510");
            break;
    }
